
breaksize=10000;
#maxsamples=12;
maxsamples=-1;

datafile=c("saved-matrices/rank-matrix.txt")
#datafile=c("test.txt")

##Read some data only to get the column names
data<-read.table(datafile,nrows=3,header=TRUE);
samplenames<-as.matrix(read.table("list-samples-clean.txt",header=TRUE,nrow=maxsamples));
probemaps<-as.matrix(read.table("probe-gene-map.txt",fill=TRUE));
genes<- unique(probemaps[,2])
genes<-genes[genes!=""];
probes<-colnames(data);

write.table(file="gene-names-all.txt",as.matrix(genes),row.names=FALSE,col.names=FALSE,quote=FALSE);

breaks<-seq(1,length(samplenames[,1])-1,by=breaksize);
breaks<-c(breaks[1:c(length(breaks)-1)],1+length(samplenames[,1]));
#show(breaks);
	
for(breakid in c(1:(length(breaks)-1)))
{
skipsize=breaks[breakid];
readsize=breaks[breakid+1]-breaks[breakid];
show(c(skipsize,readsize));
###Read these many rows from source matrix
	if(breakid==1)
	{
data<-read.table(datafile,nrows=readsize,header=TRUE);
mycolnames<-colnames(data);
rownames(data)<-data[,1];
show(mycolnames);
	}
	else
	{
data<-read.table(datafile,nrows=readsize,skip=skipsize,header=FALSE);
colnames(data)<-mycolnames;
rownames(data)<-data[,1];
	}

#show(data[,1:3]);
	newdata<-as.matrix(rownames(data));
	
	for(gene in genes)
	{
	myprobes<-probemaps[probemaps[,2]==gene,1];
	myprobes2<-paste("X",myprobes,sep="");
	myprobes<-c(myprobes,myprobes2);
	myprobes<-intersect(probes,myprobes);
	mydata<-as.matrix(data[,myprobes]);
	tmpdata<-as.matrix(apply(mydata,1,max));
	newdata<-cbind(newdata,tmpdata);

	filename<-paste("gene-wise-data/",gene,sep="");
		if(breakid==1)
		{
	show(paste("gene name:",gene));
	show(c("probes-matches",myprobes));
	write.table(file=filename,tmpdata,row.names=FALSE,col.names=FALSE);
		}
		else
		{
	write.table(file=filename,tmpdata,append=TRUE,row.names=FALSE,col.names=FALSE);
		}
	#show(dim(tmpdata));
	}
	#show(dim(newdata));

	apply(
	newdata,1,function(x){
	write.table(
	file=paste("sample-data-ranks/",x[1],sep=""),
	as.matrix(x[2:length(x)]),
	row.names=FALSE,
	quote=FALSE,
	col.names=FALSE);
	return (0);}
	)

}
warnings();
