
sqids=`cat list.failed `


mkdir -p bs-preds-arabi/

## modify paths to the following before use.
atpbin="/home/shandar/newdata/binding-sites/atp-bspred/bins/predict.sh"
atpsvm="atp.svm"
cbspredbin="/home/shandar/newdata/binding-sites/cbs-pred/cbs-pred-standalone-v2011/cbs-pred.bin"
sdcpred="/home/shandar/newdata/binding-sites/sdcpred/sdcpred-from-pssm.sh"
srcpred="/home/shandar/newdata/binding-sites/RBP-dinuc-pred/dinuScore.sh"
pprobe="/home/shandar/newdata/binding-sites/pprobe/bins/pprobe.sh"

###############

for sqid in $sqids
do
if [ ! -f bs-preds-arabi/$sqid-preds-all.txt ]; then
echo "Missing $sqid predictions.. doing"
mkdir $sqid 
cd $sqid


### Predict ATP binding sites:
echo "ATP"

`$atpbin ../pssm-arabi/$sqid.pssm $atpsvm | awk '{if(start==1 && NF==3)print $0;if($1=="V1" && $2=="pred")start=1}' > pred.atp` &>> log.tmp.atp

### Predict carbohydrate binding sites

mkdir -p data
echo "Carb"
$cbspredbin ../fasta/$sqid.fasta ../pssm-arabi/$sqid.pssm  &>> log.tmp.cbspred
awk '{if(NR>=10 && NF==3)print $1,$2}'  result-cbs-pred.txt > pred.carb


### Predict DNA-binding sites using SDC Pred
echo "DNA"
$sdcpred ../pssm-arabi/$sqid.pssm &>> log.tmp.sdcpred
awk '{print $1,($2+$3+$3+$4)/4}' result.acgt > pred.sdcpred

### Predict RNA-binding sites using SRC Pred
echo "RNA"

$srcpred ../pssm-arabi/$sqid.pssm &>> log.tmp.srcpred
awk '{sum=0;for(i=2;i<=NF;i++)sum=sum+$i;if(NR>1)print $1,sum/16}' result.txt > pred.srcpred

### Predict PPI interaction sites.

echo "PPI"
$pprobe ../pssm-arabi/$sqid.pssm ../pssm-arabi/$sqid.pssm &>> log.tmp.pprobe
awk '{if(NR>1)print $0}' $sqid.pssm-$sqid.pssm.2-pprobe.txt > pred.pprobe

echo "Position ATP Carb DNA RNA PPPI" > preds-all.txt
paste pred.atp pred.carb pred.sdcpred pred.srcpred pred.pprobe | awk '{print $2$1,$3,$5,$7,$9,$11}' >> preds-all.txt 

R -f ../plot-bs.R &>> log.tmp
cd ..

mv $sqid/preds-all.txt  bs-preds-arabi/$sqid-preds-all.txt
mv $sqid/*.pdf  bs-preds-arabi/$sqid-plot.pdf
rm -rf $sqid
fi

done
