library("parallel");
ncores=6

data=read.table("saved-matrices/gene-wise-data-ranks.txt",header=T,row.names=1,nrow=-1)
genes<-colnames(data);
#genes<-as.matrix(read.table("gene-names-all.txt"))[,1];
genes<-as.character(genes);

for(ss in c(20,100))
{
bindefs<-as.matrix(read.table(paste("bin-breaks-exp",ss,".txt",sep="")))[,1];
#genes<-genes[1:10];
allhistos<-rep(0,length(bindefs)-1);
allhistos<-rep(allhistos,length(genes));

allhistos<-matrix(allhistos,nrow=length(genes));
show(dim(allhistos));

zz<-mclapply(seq(1,length(genes)),function(geneid)
                {
                gene<-genes[geneid];
                #show(paste(geneid,gene));
                myhisto=hist(as.numeric(data[,gene]),breaks=bindefs,plot=F);
                return(myhisto$counts/sum(myhisto$counts));
                },mc.cores=ncores
        )

zz<-lapply(seq(1,length(genes)),function(geneid){allhistos[geneid,]<<- zz[[geneid]];return(0)});

rownames(allhistos)<-genes;
colnames(allhistos)<-paste("bin",seq(1,length(bindefs)-1),sep=".");

write.table(allhistos,paste("saved-matrices/gene-exp-histos-",ss,"bins.txt",sep=""),quote=F,row.names=T,col.names=T);
}
