#This script will run all other scripts required to prepare training data
#and call the neural network program nnbench to do the training.
#Data preparation will be done only if the program was called as
#new as the first argument.

params=`cat nnbench.rc`

	if [ $# -gt 0 ] ; then
	if [ $1 == "new" ] ; then
	#-----------Data Preparation-------------------
	#Create 20 bit binary representations.
echo "Creating 20 bit binary reprsentations."
	get-20bits.sh
echo "Cleaning PSSM files to extract 20 column scores, and information content files pssm and pssmic."
	pssmto20.sh


	#Change category data into pattern vectors
	list=`awk '{if(substr($1,1,1)!="#")print $0}' $params/list.class`
	for name in $list 
	do
	echo "Generating digital codes for $name"
	rm -f $params/codes.$name
	categ2vec.sh props $name
	done


	#Change numerical data into pattern vectors
	list=`awk '{if(substr($1,1,1)!="#")print $0}' $params/list.num`

	for name in $list 
	do
echo "Normalizing property $name"
	rm -f $params/range.$name
	num2frac.sh props $name
	done

	#Change the nmerical target vectors into fractional values in the range between 0 and 1.
echo "Normalizing target data"
	rm -f $params/range.o
	num2frac.sh targets o
	mkdir -p target-bins
	mv prop-bins/*.o target-bins

	#Join property vectors as instructed in list.use file
echo "Joining properities to create single file input vectors for each protein (no neighbor information yet)"
	join-props.sh 
echo "Creating input vectors with different number of neighbors"
	add-nbrs.sh

	fi
	fi

#Training
