#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include"fileprops.c"





int main(int argc,char **argv)
{
char help1[]="This program will read a two column format file. \nIt will create three files \n(1) fasta sequence from its first column (2) 21 dimensional binary coding file for all residues. and \n(3) 21 dimensional (length/100 and relative amino acid composition, with these 21d vectors repeated for all residue positions. \nIt will also create files nbr1, nbr2,  ...upto nbr8, where 21d information of 8 neighbors are appended to each row. \n" ;
char help2[]="\nPlease call the program as: ./get-21d -i <input file> -f <fasta file> -21 <21d coding file> -compo <composition file> \n " ;

char infile[1000],fastafile[1000],binfile[1000],compofile[1000],string1[40000],dumstr[1000000];
FILE *f1,*f2,*f3,*f4, *fp1, *fp2, *fp3, *fp4, *fp5, *fp6, *fp7, *fp8, *fm1, *fm2, *fm3, *fm4, *fm5, *fm6, *fm7, *fm8;
FILE *nbr1, *nbr2, *nbr3, *nbr4, *nbr5, *nbr6, *nbr7, *nbr8;
int i,j,numfields,numlines,aa[20];
char A[45]="1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
char C[45]="0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"; 
char D[45]="0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"; 
char E[45]="0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
char F[45]="0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
char G[45]="0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
char H[45]="0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
char I[45]="0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0";
char K[45]="0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0";
char L[45]="0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0";
char M[45]="0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0";
char N[45]="0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0";
char P[45]="0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0";
char Q[45]="0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0";
char R[45]="0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0";
char S[45]="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0";
char T[45]="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0";
char V[45]="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0";
char W[45]="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0";
char Y[45]="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0";
char Z[45]="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1";
char X[45]="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
char pat[45],pat0[1000],patm[20][20000],patp[20][20000];
int patsize=5000;


if(argc==1 || !strcmp(argv[1],"-") || !strcmp(argv[1],"-h") || !strcmp(argv[1],"-help") || !strcmp(argv[1],"help"))
{
printf("%s",help1);
printf("%s",help2);
}


	for(i=0;i<argc-1;i++)
	{
	if(!strcmp(argv[i],"-i"))
	strcpy(infile,argv[i+1]);
	if(!strcmp(argv[i],"-f"))
	strcpy(fastafile,argv[i+1]);
	if(!strcmp(argv[i],"-21"))
	strcpy(binfile,argv[i+1]);
	if(!strcmp(argv[i],"-compo"))
	strcpy(compofile,argv[i+1]);
	}

numlines=numl(infile);
numfields=numf(infile);

//printf("%s has %d fields and %d lines.",infile,numfields,numlines);

f1=fopen(infile,"r");

if(f1==NULL)
exit(2);

f2=fopen(fastafile,"w");

fprintf(f2,">Fasta generated from %s\n",infile);

f3=fopen(binfile,"w");
f4=fopen(compofile,"w");


fp1=fopen("plus1","w");
fp2=fopen("plus2","w");
fp3=fopen("plus3","w");
fp4=fopen("plus4","w");
fp5=fopen("plus5","w");
fp6=fopen("plus6","w");
fp7=fopen("plus7","w");
fp8=fopen("plus8","w");
fm1=fopen("minus1","w");
fm2=fopen("minus2","w");
fm3=fopen("minus3","w");
fm4=fopen("minus4","w");
fm5=fopen("minus5","w");
fm6=fopen("minus6","w");
fm7=fopen("minus7","w");
fm8=fopen("minus8","w");


		for(i=0;i<8;i++)
		{
		if(i<1)
		fprintf(fm1,"%s\n",Z);
		if(i<2)
		fprintf(fm2,"%s\n",Z);
		if(i<3)
		fprintf(fm3,"%s\n",Z);
		if(i<4)
		fprintf(fm4,"%s\n",Z);
		if(i<5)
		fprintf(fm5,"%s\n",Z);
		if(i<6)
		fprintf(fm6,"%s\n",Z);
		if(i<7)
		fprintf(fm7,"%s\n",Z);
		if(i<8)
		fprintf(fm8,"%s\n",Z);
		}


		for(i=0;i<numlines;i++)
		{
						fscanf(f1,"%s",string1);
						for(j=0;j<numfields-1;j++)
						fscanf(f1,"%s",dumstr);
						fprintf(f2,"%s",string1);
						if((i+1)%60==0)
						fprintf(f2,"\n");
		
						if(!strcmp(string1,"A")) { aa[0]++; strcpy(pat,A); }
						else
						if(!strcmp(string1,"C")) { aa[1]++; strcpy(pat,C); }
						else 
						if(!strcmp(string1,"D")) { aa[2]++; strcpy(pat,D); }
						else 
						if(!strcmp(string1,"E")) { aa[3]++; strcpy(pat,E); }
						else
						if(!strcmp(string1,"F")) { aa[4]++; strcpy(pat,F); }
						else
						if(!strcmp(string1,"G")) { aa[5]++; strcpy(pat,G); }
						else
						if(!strcmp(string1,"H")) { aa[6]++; strcpy(pat,H); }
						else
						if(!strcmp(string1,"I")) { aa[7]++; strcpy(pat,I); }
						else
						if(!strcmp(string1,"K")) { aa[8]++; strcpy(pat,K); }
						else
						if(!strcmp(string1,"L")) { aa[9]++; strcpy(pat,L); }
						else
						if(!strcmp(string1,"M")) { aa[10]++; strcpy(pat,M); }	
						else
						if(!strcmp(string1,"N")) { aa[11]++; strcpy(pat,N); }
						else
						if(!strcmp(string1,"P")) { aa[12]++; strcpy(pat,P); }
						else
						if(!strcmp(string1,"Q")) { aa[13]++; strcpy(pat,Q); }
						else
						if(!strcmp(string1,"R")) { aa[14]++; strcpy(pat,R); }
						else
						if(!strcmp(string1,"S")) { aa[15]++; strcpy(pat,S); }
						else
						if(!strcmp(string1,"T")) { aa[16]++; strcpy(pat,T); }
						else
						if(!strcmp(string1,"V")) { aa[17]++; strcpy(pat,V); }
						else
						if(!strcmp(string1,"W")) { aa[18]++; strcpy(pat,W); }
						else
						if(!strcmp(string1,"Y")) { aa[19]++; strcpy(pat,Y); }
						else
						{ strcpy(pat,X);} 
						fprintf(f3,"%s\n",pat);


			if(i>0)
			fprintf(fp1,"%s\n",pat);
			if(i>1)
			fprintf(fp2,"%s\n",pat);
			if(i>2)
			fprintf(fp3,"%s\n",pat);
			if(i>3)
			fprintf(fp4,"%s\n",pat);
			if(i>4)
			fprintf(fp5,"%s\n",pat);
			if(i>5)
			fprintf(fp6,"%s\n",pat);
			if(i>6)
			fprintf(fp7,"%s\n",pat);
			if(i>7)
			fprintf(fp8,"%s\n",pat);

			if(i<numlines-1)
			fprintf(fm1,"%s\n",pat);
			if(i<numlines-2)
			fprintf(fm2,"%s\n",pat);
			if(i<numlines-3)
			fprintf(fm3,"%s\n",pat);
			if(i<numlines-4)
			fprintf(fm4,"%s\n",pat);
			if(i<numlines-5)
			fprintf(fm5,"%s\n",pat);
			if(i<numlines-6)
			fprintf(fm6,"%s\n",pat);
			if(i<numlines-7)
			fprintf(fm7,"%s\n",pat);
			if(i<numlines-8)
			fprintf(fm8,"%s\n",pat);
		}

	for(i=0;i<8;i++)
	{
	if(i<1)
	fprintf(fp1,"%s\n",Z);
	if(i<2)
	fprintf(fp2,"%s\n",Z);
	if(i<3)
	fprintf(fp3,"%s\n",Z);
	if(i<4)
	fprintf(fp4,"%s\n",Z);
	if(i<5)
	fprintf(fp5,"%s\n",Z);
	if(i<6)
	fprintf(fp6,"%s\n",Z);
	if(i<7)
	fprintf(fp7,"%s\n",Z);
	if(i<8)
	fprintf(fp8,"%s\n",Z);
	}


for(i=0;i<numlines;i++)
	{
	for(j=0;j<20;j++)
	fprintf(f4,"%f ",(float)aa[j]/(float)numlines);

	fprintf(f4,"%f \n",(float)numlines/100);
	}
fclose(f1);
fclose(f2);
fclose(f3);
fclose(f4);
fclose(fp1);
fclose(fp2);
fclose(fp3);
fclose(fp4);
fclose(fp5);
fclose(fp6);
fclose(fp7);
fclose(fp8);
fclose(fm1);
fclose(fm2);
fclose(fm3);
fclose(fm4);
fclose(fm5);
fclose(fm6);
fclose(fm7);
fclose(fm8);

f3=fopen(binfile,"r");
fp1=fopen("plus1","r");
fp2=fopen("plus2","r");
fp3=fopen("plus3","r");
fp4=fopen("plus4","r");
fp5=fopen("plus5","r");
fp6=fopen("plus6","r");
fp7=fopen("plus7","r");
fp8=fopen("plus8","r");
fm1=fopen("minus1","r");
fm2=fopen("minus2","r");
fm3=fopen("minus3","r");
fm4=fopen("minus4","r");
fm5=fopen("minus5","r");
fm6=fopen("minus6","r");
fm7=fopen("minus7","r");
fm8=fopen("minus8","r");
nbr1=fopen("nbr1","w");
nbr2=fopen("nbr2","w");
nbr3=fopen("nbr3","w");
nbr4=fopen("nbr4","w");
nbr5=fopen("nbr5","w");
nbr6=fopen("nbr6","w");
nbr7=fopen("nbr7","w");
nbr8=fopen("nbr8","w");

	for(i=0;i<numlines;i++)
	{
	fgets(pat0,patsize,f3);
	pat0[strlen(pat0)-1]='\0';
	fgets(patp[1],patsize,fp1);
	fgets(patp[2],patsize,fp2);
	fgets(patp[3],patsize,fp3);
	fgets(patp[4],patsize,fp4);
	fgets(patp[5],patsize,fp5);
	fgets(patp[6],patsize,fp6);
	fgets(patp[7],patsize,fp7);
	fgets(patp[8],patsize,fp8);
	fgets(patm[1],patsize,fm1);
	fgets(patm[2],patsize,fm2);
	fgets(patm[3],patsize,fm3);
	fgets(patm[4],patsize,fm4);
	fgets(patm[5],patsize,fm5);
	fgets(patm[6],patsize,fm6);
	fgets(patm[7],patsize,fm7);
	fgets(patm[8],patsize,fm8);


//Removing next line characters.
for(j=1;j<9;j++)
{
patp[j][strlen(patp[j])-1]='\0';
patm[j][strlen(patm[j])-1]='\0';
}

		
fprintf(nbr1,"%s %s %s\n",pat0,patm[1],patp[1]);
fprintf(nbr2,"%s %s %s %s %s\n",pat0,patm[1],patp[1],patm[2],patp[2]);
fprintf(nbr3,"%s %s %s %s %s %s %s\n",pat0,patm[1],patp[1],patm[2],patp[2],patm[3],patp[3]);
fprintf(nbr4,"%s %s %s %s %s %s %s %s %s\n",pat0,patm[1],patp[1],patm[2],patp[2],patm[3],patp[3],patm[4],patp[4]);
fprintf(nbr5,"%s %s %s %s %s %s %s %s %s %s %s\n",pat0,patm[1],patp[1],patm[2],patp[2],patm[3],patp[3],patm[4],patp[4],patm[5],patp[5]);
fprintf(nbr6,"%s %s %s %s %s %s %s %s %s %s %s %s %s\n",pat0,patm[1],patp[1],patm[2],patp[2],patm[3],patp[3],patm[4],patp[4],patm[5],patp[5],patm[6],patp[6]);
fprintf(nbr7,"%s %s %s %s %s %s %s %s %s %s %s %s %s %s %s\n",pat0,patm[1],patp[1],patm[2],patp[2],patm[3],patp[3],patm[4],patp[4],patm[5],patp[5],patm[6],patp[6],patm[7],patp[7]);
fprintf(nbr8,"%s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s\n",pat0,patm[1],patp[1],patm[2],patp[2],patm[3],patp[3],patm[4],patp[4],patm[5],patp[5],patm[6],patp[6],patm[7],patp[7],patm[8],patp[8]);
	}

remove("plus1");
remove("plus2");
remove("plus3");
remove("plus4");
remove("plus5");
remove("plus6");
remove("plus7");
remove("plus8");
remove("minus1");
remove("minus2");
remove("minus3");
remove("minus4");
remove("minus5");
remove("minus6");
remove("minus7");
remove("minus8");

printf("\n");

return 0;
}
