#!/bin/bash

#Confirguration start:
#Change the next few line to reflect true installation directory.
installdir="/home/shandar/myprogs/pprobe/bins"
R=/usr/bin/R
blastpgp=/usr/local/ncbi/bin/blastpgp
blastdata=/data/bio/db/blast/nr



#Configuration finishes here.



#===================================================================================
# DO NOT CHANGE ANYTHING BELOW THIS 
#===================================================================================
#===================================================================================
#===================================================================================
#===================================================================================

snnspath="$installdir/snns-bins"

usage="./pprobe-fasta.sh <query protein fasta> <probing protein fasta>"

if [ -z $R ]; then
R=R
fi

if [ -z $1 ]; then
echo "No fasta file defined for first protein"
echo $usage
exit 1
else
name1=`echo $1 | awk -F\/ '{print $NF}' `
$blastpgp -i $1 -d $blastdata -j 3 -Q $name1.pssm > $name1.align
name1=$name1.pssm
echo "Query protein pssm file $name1."
fi

if [ -z $2 ]; then
echo "No fasta file defined for Second protein"
echo $usage
exit 1
else
name2=`echo $2 | awk -F\/ '{print $NF}' `
$blastpgp -i $2 -d $blastdata -j 3 -Q $name2.pssm > $name2.align
name2=$name2.pssm
echo "Probing protein pssm file $name2."
fi

if [ -d .pprobeout ]; then
echo "A directory by the name .pprobeout already exists. Data in this directory will be Overwritten!"
fi

if [ -f .pprobeout ]; then
echo "A file by the name .pprobeout already exists. This directory name will be used by this program and the existing file by this name will be deleted!"
rm -f .pprobeout
fi

if [ "$name1" == "$name2" ]; then
name2="$name1.2"
echo "Both proteins are the same. One renamed to $name2"
exit
fi

mkdir -p .$name1-$name2-pprobe
cp -f $1 .$name1-$name2-pprobe/$name1
cp -f $2 .$name1-$name2-pprobe/$name2

##################
##################
cd .$name1-$name2-pprobe
echo "Start time: `date` " > time.log

$installdir/make-pats.sh $installdir $name1 $name2 $R

echo "Pattern file completed: `date` " >> time.log


#Predict from 24 neural networks now.

let i=-1
while [ $i -le 3 ]; do
let j=-1
	while [ $j -le 3 ]; do
let m=$i+$j
	if [ $m -gt -2 ]; then
	
datfile=pats.pssm$i-nbr$j 
network=$installdir/nnets/net-$i-$j-1

awk '{if(NF>1)print $0}'  $datfile > val.pat
cp -f $network mynet.net

inunits=`awk '{if(NF>1)print NF-1}' $datfile | head -n 1`
outunits=1
$snnspath/add-pat-header.sh val.pat $inunits $outunits
$snnspath/batchman -f $snnspath/batchman.snns > log.tmp
$snnspath/flatten-snns.sh val.res > pred
mv pred pssm$i.nbr$j.pred
	fi

	let j=$j+1
done
	let i=$i+1
done

echo "Stage 1 predictions completed: `date` " >> time.log

#Create stage 2 patterns:
echo "$name"
pstart=-1
pend=3
nbrstart=-1
nbrend=3
rm -f stage2.pat
rm -f paste.string

                                k=$pstart
                                while [ $k -le $pend ];
                                do
                                                m=$nbrstart

                                                while [ $m -le $nbrend ];
                                                do
                                        let t=$k+$m
                                        if [ $t -gt -2 ]; then
                                                predfile="pssm$k.nbr$m.pred"
                                                printf  "$predfile " >> paste.string
                                                #printf "$pred "
                                        fi
                                                let m=$m+1
                                                done
                                let k=$k+1
                                done

paste `cat paste.string` > stage2.all



#Final prediction
awk '{for(i=1;i<=NF;i++)sum=sum+$i;print sum/NF;sum=0}' stage2.all > pred

paste -d "\t" lheader.txt pred > final-prediction.txt

#rm -f prob.tmp

sort -rgk 2 final-prediction.txt | head -n 20 > top20.txt

echo "Residue Score" > ../$name1-$name2-top20.txt
echo "Residue Score" > ../$name1-$name2-pprobe.txt

if [ -f final-prediction.txt ]; then
cat top20.txt >> ../$name1-$name2-top20.txt
cat final-prediction.txt >> ../$name1-$name2-pprobe.txt
echo "Calculations completed."
echo "Results are written to $name1-$name2-top20.txt and $name1-$name2-pprobe.txt files"
else
echo "Program exited with errors. Predictions could not be completed."
exit
fi

cd ..
rm -rf .$name1-$name2-pprobe
ln -s $name1-$name2-pprobe.txt pprobeplotin.txt
$R -f $installdir/plot.R > dum.txt
mv pprobeplot.jpg $name1-$name2-pprobe.jpg
echo "Graphical results are in $name1-$name2-pprobe.jpg"
rm -f pprobeplotin.txt
rm -f dum.txt
