data<-read.table("pprobeplotin.txt",as.is=TRUE,skip=1)

#Set the number of residues in each line
size=60
numlines=ceiling(nrow(data)/size)

numlines
jpeg(filename="pprobeplot.jpg",width=800,height=numlines*150)

#layout(rbind(1,2,3,4),widths=rep(1,1),heights=rep(1,5))
par(mfcol=c(numlines,1));

par(mar=c(5,3,1,0));

for ( i in c(seq(0,numlines-1)))
{
min=i*size+1
max=min(nrow(data),(i+1)*size);

mycols=rgb(data[min:max,2],mean(data[,2]),mean(data[,2]));

if(i==0)
{
barplot(data[min:max,2],names.arg=data[min:max,1],ylim=c(0,1),las=2,xlim=c(0,1.2*size),col=mycols,main=c("Predicted scores"),cex.names=1.3,space=0.2)
}
else
{
barplot(data[min:max,2],names.arg=data[min:max,1],ylim=c(0,1),las=2,xlim=c(0,1.2*size),col=mycols,cex.names=1.3,space=0.2)
}
#abline(h=mean(data[,2])+sd(data[,2]),col=c("red"),xlim=c(0,size))
y=mean(data[,2])+sd(data[,2]);
x=c(0,1.2*(max-min+1));
lines(x,c(y,y),col=c("red"),xlim=c(0,size))

y=mean(data[,2]);
lines(x,c(y,y),col=c("blue"),xlim=c(0,size))
}
legend("topright",rbind("Mean score line","Mean+SD decision line"),col=c("blue","red"),text.col=c("blue","red"),cex=1.4,lwd=2,box.lwd=0,ncol=2);
