#This script will join properties data from prop-bins as instructed in list.use
#It will also warn if the number of fields in all rows of a given protein file do not match.
#Warning will also be issued if the number of vectors (rows do not match in properties)


params=`cat nnbench.rc`
list=`cat $params/list.codes`
list2=`awk '{if(substr($1,1,1)!="#")print $0 }' $params/list.use`


indir=prop-bins
outdir=vectors

mkdir -p $outdir

for name in $list
do
echo "Processing $name"
rm -f tmp.list

	for name2 in $list2 
	do
	printf "$indir/$name.$name2 " >> tmp.list
	done

namesall=`cat tmp.list`
paste $namesall  > $outdir/$name.in

validation=`wc -l $indir/$name.* | grep -v total | awk '{print $1}' |sort -gk 1 | uniq | wc -l `
if [ $validation -gt 1 ]; then
echo "$name has non-unique number of ROWS in the data files. Please check files corresponding to it."
fi

validation=`awk '{print NF}'  $outdir/$name.in | sort -gk 1 | uniq | wc -l `
if [ $validation -gt 1 ]; then
echo "$name has non-unique number of FIELDS in the data. Please check files corresponding to it."
echo "One possible reason could be that some class data had an unknown class having no coding scheme in codes.$prop files." 
fi

rm -f tmp.list

done


rm -f tmp.header

for name2 in $list2
do
cat params/header.$name2 >> tmp.header
done
mv tmp.header $params/header.in
