#This script will read a numerical data from files and 
#Normalize to between 0 and 1. 
#Transformation is f(x)=(x-x_min)/(x_max-x_min)

params=`cat nnbench.rc`
list=`cat $params/list.codes`
datadir=$1
fileext=$2
outdir=prop-bins

if [ ! -d $outdir ];then
mkdir $outdir
fi

echo "$fileext" > $params/header.$fileext

if [ ! -f $params/range.$fileext ];then
echo "Range file not found. Creating new range file from data"
	rm -f tmp.col2
	for name in $list
	do
	awk '{print $2}' $datadir/$name.$fileext >> tmp.col2
	done

	sort -rg tmp.col2 > tmp.srt
	x_max=`head -n 1 tmp.srt`
	x_min=`tail -n 1 tmp.srt`
	echo "Range in data: $x_min to $x_max"
	echo $x_min $x_max > $params/range.$fileext
else
echo "Using existing range values. If you want to generate automated range values, delete range.$fileext and run this script again"
x_min=`awk '{print $1}' $params/range.$fileext`
x_max=`awk '{print $2}' $params/range.$fileext`
fi




for name in $list
do
echo "Processing $name"
	list2=`awk '{print $1}' $datadir/$name.$fileext`
rm -f tmp.1
	for name2 in $list2
	do
	echo $x_min  $x_max >> tmp.1
	done

paste $datadir/$name.$fileext tmp.1 | awk '{print ($2-$3)/($4-$3)}'  > $outdir/$name.$fileext
done

rm -f tmp.1 tmp.2 tmp.srt tmp.col2
