#!/bin/bash

#-------------------------------------------------------------------
#set paths and environment variables.
source ../config.sh
source env_ss.sh
#-------------------------------------------------------------------

#Two column files and list.codes

list=`cat list.codes`

#First create fasta files, 21 bit codes, neighbor data, and composition vectors.
chmod 777 data
rm -f data/train.dat data/test.dat data/all.dat
for file in $list 
do
	let i=1
	awk '{if(NF==2)print $0;if(NF==3)print $2,$3}' data/$file > data/$file.tmp
	mv data/$file.tmp data/$file

	get-20bits -i data/$file -f data/$file.fasta -compo data/$file.compo -21 data/$file.21
		while [ $i -lt 9 ]; do
		mv nbr$i data/$file.nbr$i
		let i=$i+1
		done
	awk '{print $2}' data/$file > data/$file.o
#	paste data/$file.21 data/$file.o >> data/all.dat
	paste data/$file.nbr2 data/$file.o >> data/all.dat
done
	mkdir params res log predict
	chmod 777 params res log predict
	cp $topdir/params_default/* params/
	echo "$PWD/params" > nnbench.rc

	
	awk '{if(NR%3==0)print $0}' data/all.dat > data/test.dat
	awk '{if(NR%3!=0)print $0}' data/all.dat > data/train.dat
	echo "num_layers  3"   > params/netarch.dat
	numunits=`awk '{if(NR==1)print NF-1}' data/train.dat`
	echo "num_units_each  $numunits 2 1"   >> params/netarch.dat
	echo "activation_hidden atan"   >> params/netarch.dat
	echo "activation_output sigmoidal"   >> params/netarch.dat
#	cp $topdir/params_default/tr_opt1.dat params/tr_opt.dat
#	nnbench train >& log2.txt
#	cp $topdir/params_default/tr_opt2.dat params/tr_opt.dat
#	nnbench train >& log.txt


nnbench train > log.txt
	grep Epoch log.txt > lcurve.txt
	grep Feature log.txt > features.txt
	tail -n 10 log.txt > summary.txt


nnbench eval data/all.dat > log.txt
	grep ROC log.txt > roc.txt
	grep Prediction log.txt > results.txt

	awk '{print $4,$6,$8,$10,$12,$14,$16,$18}' roc.txt > roc
	$octave < $SCPATH/plot-roc.m >& dum.txt
	convert -rotate 90 roc.ps roc.png
	awk '{print $6}' features.txt > correlations
	$octave < $SCPATH/plot-correl.m  >& dum.txt
	convert -rotate 90 correlations.ps correlations.png
	awk '{if($1!="Maximum")print $6+0,$10}' lcurve.txt > lcurve
	$octave < $SCPATH/plot-lcurve.m  >& dum.txt
	convert -rotate 90 lcurve.ps lcurve.png
	


#Copying data to html directory

	cp roc.ps $docroot/roc.ps
	cp roc.png $docroot/roc.png
	cp roc.txt $docroot/roc.txt
	cp summary.txt $docroot/summary.txt
	cp results.txt $docroot/results.txt
	cp features.txt $docroot/features.txt
	cp data/train.dat $docroot/train.txt
	cp data/test.dat $docroot/test.txt
	cp lcurve.txt $docroot/lcurve.txt
	cp correlations.ps $docroot/correlations.ps
	cp correlations.png $docroot/correlations.png
	cp lcurve.png $docroot/lcurve.png
	cp lcurve.ps $docroot/lcurve.ps
	cp $topdir/query_ss.cgi query.cgi

	cat $topdir/templates/form-top.html > $docroot/query.html
#echo "<FORM ACTION=\"$formroot/query.cgi\" METHOD=\"post\" onSubmit=\"return validate()\" ENCTYPE=\"multipart/form-data\" " >> $docroot/query.html
echo "<FORM ACTION=$formroot/query.cgi METHOD=POST >"  >> $docroot/query.html
	cat $topdir/templates/form-bottom.html >> $docroot/query.html

tar -czvf port-html.tar.gz $docroot/query.html 
tar -czvf port-cgi.tar.gz .
mv port-html.tar.gz $docroot/
mv port-cgi.tar.gz $docroot/

#Creating Links on the index page.

echo "<html>" > $docroot/index.html 
echo "Your calculations are completed!<br>" >> $docroot/index.html
echo "Click on the following links to get your results.<br>" >> $docroot/index.html
echo "<a href=$linkroot/summary.txt>Summary</a><br>" >> $docroot/index.html
echo "<a href=$linkroot/roc.txt>ROC</a><br>" >> $docroot/index.html
echo "<a href=$linkroot/results.txt>Predicted versus expected values.</a><br>" >> $docroot/index.html
echo "<a href=$linkroot/features.txt>Features summary</a><br>" >> $docroot/index.html
echo "<a href=$linkroot/train.txt>Pattern Vectors (training data)</a><br>" >> $docroot/index.html
echo "<a href=$linkroot/test.txt>Pattern Vectors (validation data, used to stop training)</a><br>" >> $docroot/index.html
echo "<a href=$linkroot/lcurve.txt>Learning history data</a><br>" >> $docroot/index.html

echo "<hline><br>" >> $docroot/index.html
echo "<br>Graphical Results may be accessed from the following links:<br>" >> $docroot/index.html
echo "<a href=$linkroot/roc.ps>ROC Curve (Postscript file)</a><br>" >> $docroot/index.html
echo "<a href=$linkroot/roc.png>ROC Curve (PNG within HTML)</a><br>" >> $docroot/index.html
echo "<a href=$linkroot/correlations.ps>Correlation between feature vectors and target property (Postscript file)</a><br>" >> $docroot/index.html
echo "<a href=$linkroot/correlations.png>Correlation between feature vectors and target property (PNG within HTML)</a><br>" >> $docroot/index.html

echo "<a href=$linkroot/lcurve.ps>Learning curve (Postscript file)</a><br>" >> $docroot/index.html
echo "<a href=$linkroot/lcurve.png>Learning curve (PNG within HTML)</a><br>" >> $docroot/index.html


echo "<br>Links to the web server and binaries of the predictor created for your data. <br>" >> $docroot/index.html
echo "<a href=$linkroot/query.html>Query page. </a><br>" >> $docroot/index.html
echo "<a href=$linkroot/port-html.tar.gz>Trained server for local installation (HTML). </a><br>" >> $docroot/index.html
echo "<a href=$linkroot/port-cgi.tar.gz>CGI of the trained server </a><br>" >> $docroot/index.html




printf "\nJob completed: ( $queryid ) :"  >> ../logs/lock.log
date=`date`
printf "$date  " >>../logs/lock.log
