load roc;
cutoff=roc(:,1);
tp=roc(:,2);
tn=roc(:,3);
fp=roc(:,4);
fn=roc(:,5);
sensi=100*roc(:,6);
speci=100*roc(:,7);
np=100*roc(:,8);
x=[0,25,50,100];
y=100-x;
hold on;
xlabel("Sensitivity (%)");
ylabel("Specificity (%)");
title("ROC Graphs for Neural network Predictions.");
plot(x,y,"b;Base line with no predictiability (sensitivity+specificity=100%);");
plot(sensi,speci,"r;Results from cross validated predictions.;");
gset terminal postscript enhanced color solid lw 2 "Times-Roman" 12;
gset output "roc.ps";
