#!/usr/bin/perl -w
#
# A script to convert a number of java source files from dos line
# ending format to unix line format.
# Source copied from: http://www.technocage.com/~caskey/dos2unix/dos2unix
# Usage: dos2unix <DIRECTORY>
#

$directory = shift @ARGV;
$directory = '.' unless $directory;
chdir( $directory ) || die "Unable to enter directory '$directory'.\n$!\n";

@files = <*.java>;
$| = 1;
$linesFixed = 0;
foreach( @files ) {
    print "$_\t";
    open(INPUT, "<$_");
    rename( $_, "$_.bak") || die "Unable to rename $_\n$!\n";
    open(OUTPUT, ">$_");
    while(<INPUT>) {
	if ( s/\r\n/\n/ ) {
	    $linesFixed++;
	}
	print OUTPUT;
    }
} continue {
    print "($linesFixed)\n";
    $linesFixed = 0;
    close INPUT;
    close OUTPUT;
}

