#This script will read name of pdbcodes from list.codes file
#and then read amino acid names from the first column of targets/$code.o files and 
#produce 20 bit representation vectors for each amino acid.
#Results will be written in props-bin/ directory

params=`cat nnbench.rc`
list=`cat $params/list.codes`
outdir=prop-bins
indir=targets

printf "A \nC \nD \nE \nF \nG \nH \nI \nK \nL \nM \nN \nP \nQ \nR \nS \nT \nV \nW \nY \n" | awk '{printf "20d:"$1"\n"}' > $params/header.20

for filename in $list
do
echo "Processing $filename"

awk '{if(NF>0)print $0}' $indir/$filename.o | awk '{ x=0; 
if($1=="A"){printf "1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";x=1}; 
if($1=="C"){printf "0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";x=1}; 
if($1=="D"){printf "0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";x=1}; 
if($1=="E"){printf "0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";x=1}; 
if($1=="F"){printf "0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";x=1}; 
if($1=="G"){printf "0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0";x=1}; 
if($1=="H"){printf "0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0";x=1}; 
if($1=="I"){printf "0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0";x=1}; 
if($1=="K"){printf "0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0";x=1}; 
if($1=="L"){printf "0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0";x=1}; 
if($1=="M"){printf "0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0";x=1}; 
if($1=="N"){printf "0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0";x=1}; 
if($1=="P"){printf "0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0";x=1}; 
if($1=="Q"){printf "0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0";x=1}; 
if($1=="R"){printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0";x=1}; 
if($1=="S"){printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0";x=1}; 
if($1=="T"){printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0";x=1}; 
if($1=="V"){printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0";x=1}; 
if($1=="W"){printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0";x=1}; 
if($1=="Y"){printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1";x=1}; 
if(x==0) {printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";x=1}; printf "\n"; }'  > $outdir/$filename.20 

done
