timestamp=`date +%y%m%d%H%M`
echo "Starting to setup nnbench and training in $timestamp"
params=`cat nnbench.rc`

list=`cat $params/list.train`
list2=`cat $params/list.test`
list3=`cat $params/list.val`
vecdir="vectors"
tardir="target-bins"
datadir="data"
#Following is the extension of files to be used as input vectors.
vecext="3nbr"
layers=3
#inputunits= To be read from data files.
otherunits="2 1"

rm -f $datadir/train.dat $datadir/test.dat $datadir/val.dat
for name in $list
do
paste $vecdir/$name.$vecext $tardir/$name.o >> $datadir/train.dat
done

for name in $list2
do
paste $vecdir/$name.$vecext $tardir/$name.o >> $datadir/test.dat
done

for name in $list3
do
paste $vecdir/$name.$vecext $tardir/$name.o >> $datadir/val.dat
done

#create a neural network
inputunits=`awk '{if(NR==1)print NF-1}' $datadir/train.dat`

echo "num_layers  $layers" > $params/netarch.dat
echo "num_units_each  $inputunits $otherunits" >> $params/netarch.dat

#../src2/a.out train > results
awk '{if(start==1 && $1=="Maxima")end=1;if(start==1 && end==0)print $0;if($1=="Maxima")start=1}' results > tmp.sum
paste $params/header.$vecext tmp.sum > summary.txt
